RET=0
GFLAGS=""
FILTER="cat"
SUFFIX=""
MAX=

exec 3>/tmp/.wo.$$

clean() {
	rm -f /tmp/.wo$$ /tmp/.wo.$$
	exit $RET
}

trap clean 2 3

usage() {
	echo >&2 "usage: without [-iV] [-F filter] [-m maxdepth] [-p pattern]"
	echo >&2 "([ -r regexp ] | regexp ) [-s suffix] regexp [file ...]"
	exit 1
}

while getopts F:im:p:r:s: i
do
	case $i in
	F)	FILTER="$OPTARG";;
	i)	GFLAGS="-i";;
	m)	MAX="$OPTARG";;
	p)	PATTERN="$OPTARG";;
	r)	REGEXP="$OPTARG";;
	s)	case "$OPTARG" in
		.*)	SUFFIX="-name '*$OPTARG'";;
		*)	SUFFIX="-name '*.$OPTARG'";;
		esac
		;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

if	[ X"$REGEXP" = "X" ]
then	if	[ "$#" -lt 1 ]
	then	usage
	else	REGEXP="$1"
		shift
	fi
fi

FILES="${*:-.}"

for i in $FILES
do
	if	[ -d "$i" ]
	then	eval "find \"$i\" -type f $SUFFIX -print"
	else	echo "$i"
	fi
done | while read j
do	if	$FILTER <"$j" | grep $GFLAGS "$REGEXP" >/dev/null
	then	:
	else	echo "$j"
	fi
done 2>&3

RET=$?

if	[ -s /tmp/.wo.$$ ]
then	echo >&2 "Some files or directories could not be read."
	RET=1
fi

clean

exit $RET
