RET=0
FILTER="cat"
DEPTH=1
SUFFIX=""
MAX=""
GFLAGS=""

clean() {
	rm -f /tmp/.with$$
	exit $RET
}

trap clean 2 3

usage() {
	echo >&2 "usage: with [-iV] [ -F filter ] [ -m maxdepth ]"
	echo >&2 "[ -p pattern ] [ -s suffix ] ( [ -r regexp ] | regexp ) [ file ... ]"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

while getopts F:im:pr:s:V i
do
	case $i in
	F)	FILTER="$OPTARG";;
	i)	GFLAGS="-i";;
	m)	MAX="$OPTARG";;
	r)	REGEXP="$OPTARG";;
	p)	PATTERN="$OPTARG";;
	s)	case "$OPTARG" in
		.*)	SUFFIX="-name '*$OPTARG'";;
		*)	SUFFIX="-name '*.$OPTARG'";;
		esac
		;;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

if	[ X"$REGEXP" = "X" ]
then	if	[ "$#" -lt 1 ]
	then	usage
	else	REGEXP="$1"
		shift
	fi
fi

FILES="${*:-.}"

for i in $FILES
do
	if	[ -d "$i" ]
	then	eval "find \"$i\" -type f $SUFFIX -print"
	else	echo "$i"
	fi
done | while read j
do	if	$FILTER <"$j" | grep $GFLAGS "$REGEXP" >/dev/null
	then	echo "$j"
	fi
done 2>/tmp/.with$$

RET=$?

if	[ -s /tmp/.with$$ ]
then	echo >&2 "Some files or directories could not be read."
	RET=1
fi

clean

exit $RET
