BEEP="N"
SEC=10
VERBOSE="NO"
TIMESTAMP="NO"
STDERR=

usage() {
	echo >&2 "usage: waitfor [-V] [-gqtv] [-s sec] command [args ...]"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

while getopts "gqs:tvV" i
do
	case $i in
	g)	BEEP="Y";;
	q)	STDERR="2>/dev/null";;
	s)	SEC="$OPTARG";;
	v)	VERBOSE="YES";;
	t)	TIMESTAMP="YES";;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

until	eval "PATH='$SAVEPATH' $* $STDERR"
do	[ X"$TIMESTAMP" = "XYES" ] && [ X"$VERBOSE" = "XYES" ] && date
	sleep $SEC || exit 1
done
[ X"$TIMESTAMP" = "XYES" ] && date
[ X"$BEEP" = "Y" ] && echo 
