/* verb: verbalize characters on input */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct {
	char *name, *long_name;
} names[] = {
	{ "nul", "null character" },
	{ "soh", "control-A" },
	{ "stx", "control-B" },
	{ "etx", "control-C" },
	{ "eot", "control-D" },
	{ "enq", "control-E" },
	{ "ack", "control-F" },
	{ "bel", "control-G" },
	{ "bs", "control-H" },
	{ "ht", "control-I" },
	{ "nl", "control-J" },
	{ "vt", "control-K" },
	{ "np", "control-L" },
	{ "cr", "control-M" },
	{ "so", "control-N" },
	{ "si", "control-O" },
	{ "dle", "control-P" },
	{ "dc1", "control-Q" },
	{ "dc2", "control-R" },
	{ "dc3", "control-S" },
	{ "dc4", "control-T" },
	{ "nak", "control-U" },
	{ "syn", "control-V" },
	{ "etb", "control-W" },
	{ "can", "control-X" },
	{ "em", "control-Y" },
	{ "sub", "control-Z" },
	{ "escape", "%s" },
	{ "fs", "control-\\" },
	{ "gs", "control-]" },
	{ "rs", "control-^" },
	{ "us", "control-_" },
	{ "space", "%s" },
	{ "bang", "exclamation mark" },
	{ "quote", "double-%s" },
	{ "octothorpe", "pound/sharp/hash/octothorpe" },
	{ "dollars", "%s sign" },
	{ "percent", "%s sign" },
	{ "and", "ampersand" },
	{ "apostrophe", "single-quote" },
	{ "open", "%s parenthesis" },
	{ "close", "%s parenthesis" },
	{ "star", "asterisk" },
	{ "plus", "%s sign" },
	{ "comma", "%s" },
	{ "minus", "%s sign" },
	{ "dot", "period" },
	{ "slash", "forward %s" },
	{ "zero", "numeral %s" },
	{ "one", "numeral %s" },
	{ "two", "numeral %s" },
	{ "three", "numeral %s" },
	{ "four", "numeral %s" },
	{ "five", "numeral %s" },
	{ "six", "numeral %s" },
	{ "seven", "numeral %s" },
	{ "eight", "numeral %s" },
	{ "nine", "numeral %s" },
	{ "colon", "%s" },
	{ "semicolon", "%s" },
	{ "less than", "%s" },
	{ "equals", "%s sign" },
	{ "greater than", "%s" },
	{ "question mark", "question mark" },
	{ "at", "at sign" },
	{ "capital ay", "%s" },
	{ "capital bee", "%s" },
	{ "capital see", "%s" },
	{ "capital dee", "%s" },
	{ "capital ee", "%s" },
	{ "capital eff", "%s" },
	{ "capital gee", "%s" },
	{ "capital aitch", "%s" },
	{ "capital aye", "%s" },
	{ "capital jay", "%s" },
	{ "capital kay", "%s" },
	{ "capital ell", "%s" },
	{ "capital em", "%s" },
	{ "capital en", "%s" },
	{ "capital oh", "%s" },
	{ "capital pee", "%s" },
	{ "capital queue", "%s" },
	{ "capital are", "%s" },
	{ "capital ess", "%s" },
	{ "capital tee", "%s" },
	{ "capital you", "%s" },
	{ "capital vee", "%s" },
	{ "capital double-you", "%s" },
	{ "capital ex", "%s" },
	{ "capital why", "%s" },
	{ "capital zee", "%s" },
	{ "open square", "%s bracket" },
	{ "backslash", "backwards slash" },
	{ "close square", "%s bracket" },
	{ "caret", "%s" },
	{ "underscore", "%s" },
	{ "backquote", "%s" },
	{ "ay", "lowercase %s" },
	{ "bee", "lowercase %s" },
	{ "see", "lowercase %s" },
	{ "dee", "lowercase %s" },
	{ "ee", "lowercase %s" },
	{ "eff", "lowercase %s" },
	{ "gee", "lowercase %s" },
	{ "aitch", "lowercase %s" },
	{ "aye", "lowercase %s" },
	{ "jay", "lowercase %s" },
	{ "kay", "lowercase %s" },
	{ "ell", "lowercase %s" },
	{ "em", "lowercase %s" },
	{ "en", "lowercase %s" },
	{ "oh", "lowercase %s" },
	{ "pee", "lowercase %s" },
	{ "queue", "lowercase %s" },
	{ "are", "lowercase %s" },
	{ "ess", "lowercase %s" },
	{ "tee", "lowercase %s" },
	{ "you", "lowercase %s" },
	{ "vee", "lowercase %s" },
	{ "double-you", "lowercase %s" },
	{ "ex", "lowercase %s" },
	{ "why", "lowercase %s" },
	{ "zee", "lowercase %s" },
	{ "open brace", "open squiggly brace" },
	{ "pipe", "vertical pipe" },
	{ "close brace", "open squiggly brace" },
	{ "tilde", "tilde" },
	{ "del", "delete" },
};


int
main(int argc, char *argv[]) {
	int c;
	char *s;
	int tlen = 0;
	int len = 0;
	char buf[80];
	static char hexdigit[16] = "0123456789abcdef";
	int verbose = 0;

	while ((c = getchar()) != EOF) {
		if (c < 128) {
			if (verbose) {
				sprintf(buf, names[c].long_name, names[c].name);
				s = buf;
			} else {
				s = names[c].name;
			}
		} else {
			if ((c & 0xF0) == 0x80) {
				sprintf(buf, "hex eighty %s",
					names[(int) hexdigit[(c & 0x0F)]].name);
			} else if ((c & 0xF0) == 0x90) {
				sprintf(buf, "hex ninety %s",
					names[(int) hexdigit[(c & 0x0F)]].name);
			} else {
				sprintf(buf, "hex %s %s",
					names[(int) hexdigit[(c & 0xF0) >> 4]].name,
					names[(int) hexdigit[(c & 0x0F)]].name);
				
			}
			s = buf;
		}
		len = strlen(s);
		if (tlen + len > 75) {
			printf(",\n%s", s);
			tlen = len;
		} else {
			printf("%s%s", tlen ? ", " : "", s);
			tlen += len + (tlen ? 2 : 0);
		}
	}
	if (tlen != 0)
		printf(".\n");

	return 0;
}

