RETVAL=0
VERBOSE="N"
SUFFIX=".bak"
DIR=.
tmp=/tmp/.shlog.$$

usage() {
	echo >&2 "usage: restore [-vV] [-d dir] [-s suffix] [pattern]"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

while getopts "d:s:vV" i
do
	case $i in
	d)	DIR="$OPTARG";;
	s)	case "$OPTARG" in
		.*)	SUFFIX="$OPTARG";;
		*)	SUFFIX=".$OPTARG";;
		esac
		;;
	v)	VERBOSE="Y";;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

case $# in
0)	PAT="*";;
1)	PAT="*$1*";;
*)	usage;;
esac

case "$SUFFIX" in
"")	usage;;
*)	FIND="find \$DIR -type f -name '*$SUFFIX' -print "
esac

proc() {
	for i
	do
		case "$i" in
		$PAT)	d=`dirname "$i"`
			j="$d/"`basename "$i" "$SUFFIX"`
			[ "$VERBOSE" = "Y" ] && echo >&2 "Moving $i..."
			mv -f "$i" "$j" || RETVAL=1
			;;
		esac
	done
}

eval $FIND | while read i
do	proc "$i"
done

exit $RETVAL
