#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "opts.h"
#include "sz.h"
#include "version.h"

static int cclass(int);

static int proc_fp(FILE *);
int checktok(int, int);
int checkws(int, int);
int (*checkbreak)(int, int) = checktok;
int (*checknotok)(int) = isspace;
enum { C_SPACE, C_ALNUM, C_PUNCT, C_OTHER };

int
cclass(int c) {
	if (isalnum(c))
		return C_ALNUM;
	if (isspace(c))
		return C_SPACE;
	if (ispunct(c))
		return C_PUNCT;
	return C_OTHER;
}

int
checktok(int lastc, int c) {
	if (cclass(lastc) != cclass(c))
		return 1;
	return 0;
}

int
checkws(int lastc, int c) {
	if (!!cclass(lastc) != !!cclass(c))
		return 1;
	return 0;
}

static int
proc_fp(FILE *fp) {
	sz *token = 0;
	int c, lastc = 0;

	while ((c = fgetc(fp)) != EOF) {
		if (!token) {
			if (checknotok(c))
				continue;
			token = str2sz("");
			if (!token)
				return 1;
			szccat(token, c);
		} else {
			if (checkbreak(lastc, c)) {
				szccat(token, '\n');
				fwrite(szdata(token), 1, szlen(token),
					stdout);
				if (!checknotok(c)) {
					szcpy(token, "");
					szccat(token, c);
				} else {
					szfree(token);
					token = 0;
				}
			} else {
				szccat(token, c);
			}
		}
		lastc = c;
	}
	if (token) {
		szccat(token, '\n');
		fwrite(szdata(token), 1, szlen(token), stdout);
	}
	szfree(token);
	token = 0;
	return 0;
}

int
main(int argc, char *argv[]) {
	int c;
	int ret = 0;

	char *us = argv[0];

	if (us && *us) {
		us = strrchr(us, '/');
		if (us)
			++us;
		else
			us = argv[0];
	}

	if (!us)
		us = "tok";

        while ((c = optsopt(argc, argv, "wV")) != -1) {
		switch (c) {
		case 'w':
			checkbreak = checkws;
			break;
		case 'V':
			version();
			break;
		default:
			fprintf(stderr, "usage: tok [-wV] [file ...]\n");
			return EXIT_FAILURE;
			break;
		}
	}
	 
	if (optsind < argc) {
		int i;
		FILE *fp;
		for (i = optsind; i < argc; ++i) {
			fp = fopen(argv[i], "r");
			if (!fp) {
				fprintf(stderr, "%s: can't open file '%s'.\n",
					us, argv[i]);
				ret = 1;
			} else {
				ret |= proc_fp(fp);
				fclose(fp);
			}
		}
	} else {
		ret = proc_fp(stdin);
	}
	return ret ? EXIT_FAILURE : EXIT_SUCCESS;
}
