/* Started Dec 5, 1994 at Xerox.
 * All wrongs reversed. */
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "opts.h"
#include "version.h"

void usage(void);

void
usage(void) {
	fprintf(stderr, "usage: timer [-xV]\n");
	exit(EXIT_FAILURE);
}

int
main(int argc, char *argv[]) {
	int opt;
	char format[] = "%lu\n";

	while ((opt = optsopt(argc, argv, "xV")) != -1) {
		switch (opt) {
		case 'x':
			format[2] = 'x';
			break;
		case 'V':
			version();
			break;
		case '?':
		default:
			usage();
			break;
		}
	}

	if (printf(format, (unsigned long) time(NULL)) != 0)
		return 0;
	return 1;
}
