CPIO="N"
RETVAL=0
LOG="N"
VERBOSE="N"
SED='sed -e "s/$FROM/$TO/$GLOBAL"'
GLOBAL="g"
BAK="Y"
DIR=.
tmp=/tmp/.shlog.$$

usage() {
	echo >&2 "usage: switch [-bcFglvVy] [-d dir] [-s suffix] from to [file ...]"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

while getopts bcd:Fgls:vVy i
do
	case $i in
	b)	BAK="N";;
	c)	CPIO="Y";;
	d)	DIR="$OPTARG"
		CPIO="YUP"
		;;
	F)	CPIO="YUP";;
	g)	GLOBAL="";;
	l)	LOG="Y";;
	s)	case "$OPTARG" in
		.*)	SUFFIX="$OPTARG";;
		*)	SUFFIX=".$OPTARG";;
		esac
		CPIO="YUP"
		;;
	v)	VERBOSE="Y";;
	V)	version;;
	y)	SED='tr "$FROM" "$TO"'
		GLOBAL=""
		;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

if	[ X"$CPIO" = "XYUP" ]
then	case "$SUFFIX" in
	"")	 FIND="find '$DIR' -type f -print ";;
	*)	 FIND="find '$DIR' -type f -name '*$SUFFIX' -print ";;
	esac
fi

if [ $# -lt 2 ]
then	usage
else	# You are not expected to understand this.
	# First, we turn each / into :::/, then we
	# turn each : into \.  The three \'s end up
	# producing a single \ for tr, of course.  Then,
	# below, when we replace '$FROM' with the
	# value of $FROM, one of the \'s is eaten, then,
	# when we eval $SED, another is eaten, leaving one
	# \ to protect sed from misunderstanding /.
	FROM=`echo "$1" | sed -e 's!/!:::/!g' | tr : '\\\'`
	TO=`echo "$2" | sed -e 's!/!:::/!g' | tr : '\\\'`
	shift 2
fi

[ "$LOG" = "Y" ] && exec 3>$tmp

SED=`echo $SED | sed -e "s/"'$FROM'"/$FROM/" -e "s/"'$TO'"/$TO/" -e "s/"'$GLOBAL'"/$GLOBAL/`

proc() {
	for i
	do
		if [ -r "$i" ]
		then	[ "$VERBOSE" = "Y" ] && echo >&2 "$i"
			[ "$BAK" = "Y" ] && cp "$i" "$i.bak"
			eval $SED < "$i" > "$i.tmp" && mv -f "$i.tmp" "$i"
			[ "$LOG" = "Y" ] && echo "$i" >&3 $tmp
		else	echo >&2 "Cannot read \`$i'."
			RETVAL=1
		fi
	done
}

if [ $# -eq 0 ]
then	case $CPIO in
	"YUP")	eval $FIND | while read i
		do	proc "$i"
		done
	;;
	"Y")	while read i
		do	proc "$i"
		done
	;;
	"N")	eval $SED
	;;
	esac
else	proc "$@"
fi

if [ "$LOG" = "Y" ]
then	cat $tmp
	rm -f $tmp
fi

exit $RETVAL
