/* Started Dec 5, 1994.  Copyright 1994-1998, Peter Seebach.  All rights
 * reserved.  All wrongs reversed. */
#define _POSIX_SOURCE
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <termios.h>

#ifdef __USLC__
extern int tgetent(char *, char *);
extern char *tgetstr(char *, char **);
#else
typedef unsigned int u_int;
#include <curses.h>
#endif

#include "opts.h"
#include "version.h"

int ctmode, amode, cmode, hmode, nmode; /* modes affecting raw_to_hex */
int pmode; /* which function to use */

char *so, *se;

static int hex_to_raw(FILE *);
static int raw_to_hex(FILE *);

static int
hex_to_raw(FILE *fp) {
	int c;
	while (fscanf(fp, "%x", &c) == 1) {
		if (nmode && c == '\n')
			putchar('\r');
		putchar(c);
	}
	fclose(fp);
	return 0;
}

static int
raw_to_hex(FILE *fp) {
	int c, i;
	int counter = 0;
	int cbuf[16];
	int itty = isatty(fileno(fp)), f = fileno(fp);
	int oldfakeeof = 0;
	struct termios buf, savebuf;

	if (itty) {
		tcgetattr(f, &buf);
		tcgetattr(f, &savebuf);
		buf.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL | ICANON | ISIG);
		oldfakeeof = buf.c_cc[VEOF];
		buf.c_cc[VMIN] = 1;
		buf.c_cc[VTIME] = 0;
		if (tcsetattr(f, TCSANOW, &buf) == 1)
			perror("tcsetattr");
	}
	while ((c = fgetc(fp)) != EOF) {
		c = (int) (unsigned int) c;
		cbuf[counter % 16] = c;
		if (!(counter % 16)) {
			/* beginning of a row */
			if (ctmode) {
				printf("0x%06x  ", counter);
			}
		}
		printf("%02x%c", c, (cmode || nmode) ? ' ' : '\n');
		if (cmode && (counter % 4) == 3) {
			putchar(' ');
		}
		if (cmode && (counter % 16) == 15) {
			if (amode) {
				putchar('\'');
				for (i = 0; i < 16; ++i) {
					if (isprint(cbuf[i]))
						putchar(cbuf[i]);
					else if (hmode && (cbuf[i] < 32))
						printf("%s%c%s",
							so, cbuf[i] + ('A' - 1), se);
					else
						putchar('.');
				}
				putchar('\'');
			}
			putchar('\n');
		}
		++counter;
		if (itty && c == oldfakeeof)
			break;
	}
	if (amode && (counter % 16)) {
		for (i = counter % 16; i < 16; ++i) {
			printf("   ");
			if ((i % 4) == 3)
				putchar(' ');
			cbuf[i] = ' ';
		}
		putchar('\'');
		for (i = 0; i < 16; ++i) {
			if (isprint(cbuf[i]))
				putchar(cbuf[i]);
			else if (hmode && (cbuf[i] < 32))
				printf("%s%c%s", so, cbuf[i] + ('A' - 1), se);
			else
				putchar('.');
		}
		putchar('\'');
	}
	if (cmode && (counter % 16))
		putchar('\n');
	if (itty) {
		tcsetattr(f, TCSANOW, &savebuf);
	}
	fclose(fp);
	return 0;
}

int
main(int argc, char *argv[])
{
	int c, retflag = 0, i;
	FILE *fp;
	char bp[1024], *s;
	int (*funcp)(FILE *) = raw_to_hex;

	while ((c = optsopt(argc, argv, "achntpV")) != -1) {
		switch (c) {
			case 'p':
				funcp = hex_to_raw;
				pmode = 1;
				break;
			case 'n':
				nmode = 1;
				/* -n implies -p */
				funcp = hex_to_raw;
				pmode = 1;
				break;
			case 'a':
				amode = 1;
				cmode = 1; /* amode implies cmode */
				break;
			case 'c':
				cmode = 1;
				break;
			case 'h':
				hmode = 1;
				/* hmode implies -c and -a */
				amode = 1;
				cmode = 1;
				break;
			case 't':
				ctmode = 1;
				cmode = 1;
				break;
			case 'V':
				version();
				break;
			case '?':
			default:
				fprintf(stderr, "usage: raw [-V] [-actn]|[-p[n]] [file ...]\n");
				exit(EXIT_FAILURE);
				break;
		}
	}
	if ((cmode || amode || ctmode || hmode) && pmode) {
		fprintf(stderr, "error: -p incompatible with any of -acht.\n");
		exit(EXIT_FAILURE);
	}

	s = getenv("TERM");
	if (!s)
		s = "tty";

	if (tgetent(bp, s) == 1) {
		char *t;
		s = bp;

		se = tgetstr("se", &s);
		if (!se)
			se = "";
		t = malloc(strlen(se) + 1);
		strcpy(t, se);
		se = t;

		s = getenv("TERM");
		if (!s)
			s = "tty";
		tgetent(bp, s);

		so = tgetstr("so", &s);
		if (!so)
			so = "";
		t = malloc(strlen(so) + 1);
		strcpy(t, so);
		so = t;
	} else {
		so = "";
		se = "";
	}

	if (optsind < argc) {
		for (i = optsind; i < argc; ++i) {
			fp = fopen(argv[i], "r");
			if (!fp) {
				fprintf(stderr, "error: couldn't open file '%s'.\n", argv[i]);
				retflag = 1;
			} else
				retflag |= funcp(fp);
		}
	} else {
		retflag = funcp(stdin);
	}
	return 0;
}
