#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "opts.h"
#include "version.h"

#define DEFAULT_BSIZE 1024

char *us = 0;
int bsize = DEFAULT_BSIZE;
int pc = '\0';
int ret = 0;
int padflag = 0;
char *buf = 0;

static int parse(char *);
static int proc_fp(FILE *);

static int
parse(char *s) {
	char *t = s;
	long sz = strtol(t, &t, 10);

	if (sz > 0) {
		switch (*t) {
		case '\0':
			break;
		case 'b':
			sz *= 512; break;
		case 'k':
			sz *= 1024; break;
		case 'm':
			sz *= 1024 * 1024; break;
		default:
			fprintf(stderr, "%s: unknown size modifier '%c'\n",
				us, *t);
			ret = 1;
			sz = 0;
		}
	}
	return sz;
}

static int
proc_fp(FILE *fp) {
	int count = 0;
	int res;

	if (!padflag) {
		while (1) {
			res = fread(buf + count, 1, bsize - count, fp);
			count += res;

			if (feof(fp))
				break;

			if (count == bsize) {
				fwrite(buf, 1, bsize, stdout);
				count = 0;
			}
		}
		if (count) {
			if (count < bsize) {
				memset(buf + count, pc, bsize - count);
			}
			fwrite(buf, 1, bsize, stdout);
		}
		return 0;
	} else {
		while (!feof(fp)) {
			res = fread(buf, 1, bsize, fp);
			if (res > 0) {
				if (res < bsize) {
					memset(buf + res, pc, bsize - res);
				}
				fwrite(buf, 1, bsize, stdout);
			}
		}
		return 0;
	}
}

int
main(int argc, char *argv[]) {
	int c;

	us = argv[0];

	if (us && *us) {
		us = strrchr(us, '/');
		if (us)
			++us;
		else
			us = argv[0];
	}

	if (!us)
		us = "pad";

        while ((c = optsopt(argc, argv, "b:c:pV")) != -1) {
		switch (c) {
		case 'p':
			padflag = optsval.v_int;
			break;
		case 'b':
			bsize = parse(optsarg);
			break;
		case 'c':
			switch (*optsarg) {
			case '\\':
				switch (optsarg[1]) {
				case 'x':
					pc = strtol(optsarg + 2, NULL, 16);
					break;
				case '0': case '1': case '2': case '3':
					pc = strtol(optsarg + 2, NULL, 8);
					break;
				case 'n':
					pc = '\n';
					break;
				case 'b':
					pc = '\b';
					break;
				case 'r':
					pc = '\r';
					break;
				case 'a':
					pc = '\a';
					break;
				case '\\':
					pc = '\\';
					break;
				default:
					fprintf(stderr, "%s: unknown escape sequence '%s'\n", us, optsarg + 2);

				}
				break;
			default:
				pc = *optsarg;
				break;
			}
			break;
		case 'V':
			version();
			break;
		default:
			fprintf(stderr, "usage: pad [-pV] [-b blocksize] [-c char] [file ...]\n");
			ret = 1;
			break;
		}
	}
	 
	if (ret)
		exit(EXIT_FAILURE);

	buf = malloc(bsize);
	if (!buf)
		exit(EXIT_FAILURE);
	
	if (optsind < argc) {
		int i;
		FILE *fp;
		for (i = optsind; i < argc; ++i) {
			fp = fopen(argv[i], "r");
			if (!fp) {
				fprintf(stderr, "%s: can't open file '%s'.\n",
					us, argv[i]);
				ret = 1;
			} else {
				ret |= proc_fp(fp);
				fclose(fp);
			}
		}
	} else {
		ret |= proc_fp(stdin);
	}
	return ret ? EXIT_FAILURE : EXIT_SUCCESS;
}
