DO="eval"
VERBOSE=":"
PATH="$SAVEPATH"

usage() {
	echo >&2 "usage: open [-nvV] file [file ...]"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

id() {
	TYPE="unknown"
	TARGET="nothing"
	TYPE="unknown"
	DECOMP="cat"
	NAME=""

	case "$1" in
	"")	return 1;;
	*.*)	SUFFIX=`echo "$1" | sed -e 's/^[^.]*//'`;;
	*)	SUFFIX="";;
	esac
	FILE=`file $1`
	RSUFFIX="$SUFFIX"

	TYPE="unreadable"
	[ ! -r "$1" ] && return 1

	case "$SUFFIX:$FILE" in
	*.tgz:*|*.tar.gz:*)
		SUFFIX=".tar"
		NAME="gzipped "
		FILE="tar file"
		DECOMP="gzip -dc"
		;;
	*.taz:*compress*|*.tar.Z:*compress*)
		SUFFIX=".tar"
		NAME="compressed "
		FILE="tar file"
		DECOMP="uncompress -c"
		;;
	*.gz:*|*:gzip*)
		SUFFIX=`echo "$SUFFIX" | sed -e 's/\.gz//'`
		CSUFFIX=".gz"
		NAME="gzipped "
		TYPE="compress"
		DECOMP="gzip -dc"
		RETRY="Y"
		;;
	*.Z:*|*:*compress*)
		SUFFIX=`echo "$SUFFIX" | sed -e 's/\.Z//'`
		CSUFFIX=".Z"
		NAME="compressed "
		TYPE="compress"
		DECOMP="uncompress -c"
		RETRY="Y"
		;;
	esac

	case "$SUFFIX:$FILE" in
	*:tar*|*.tar:*)
		TARGET=`echo $1 | sed -e 's/\.t[ag][rz].*$//'`
		TYPE="arch"
		ALIST="tar tf -"
		VLIST="tar tvf -"
		AOPEN="tar xf -"
		NAME="${NAME}tar archive"
		;;
	*:uuencoded*|.uu:*)
		NAME="${NAME}uuencoded file"
		TYPE="uuencode"
		RETRY="Y"
		;;
	*.shar:*)
		TYPE="arch"
		NAME="${NAME}shar file"
		ALIST="echo \$RESULT"
		AOPEN="sh"
		;;
	*.cpio:*|*:*cpio*)
		case "$FILE" in
		*char*|*ASCII*)	C="c";;
		*)	C="";;
		esac
		NAME="${NAME}cpio archive"
		TARGET=`echo $1 | sed -e 's/\.cpio.*$//'`
		TYPE="arch"
		ALIST="cpio it$C"
		VLIST="cpio ivt$C"
		AOPEN="cpio imd$C"
		;;
	*)	NAME="${NAME}file"
		;;
	esac	
}

result() {
	case "$1" in
	"")	return 1;;
	esac

	TDIR=.
	case "$TYPE" in
	arch)	RESULT=`( $DECOMP "$1" | $ALIST | sed -e 's!/$!!' -e 1q )`
		if	[ "$RESULT" != "." ] && ( $DECOMP "$1" | $VLIST | sed 1q | grep '^ *d' >/dev/null )
		then	TARGET="$RESULT"
		else	TDIR=`basename "$1" "$RSUFFIX"`
			[ X"$DO" = X"eval" ] && ( mkdir $TDIR || RETVAL=1 )
		fi
		;;
	compress)
		RESULT=`basename "$1" "$CSUFFIX"`
		;;
	uuencode)
		RESULT=`$DECOMP "$1" | sed -ne '
			/^begin [0-9]*/ {
				s/^begin [0-9]* //
				p
				q
			}'`
		;;
	esac

	case "$RESULT" in
	"$1")	echo >&2 "\n'$1' would create itself, making '$1.out'."
		RESULT="$1.out";;
	esac
}

proc() {
	case "$TYPE" in
	arch)
		$VERBOSE >&2 "( $DECOMP '$1' | $AOPEN ) || RETVAL=1"
		$DO >&2 "( $DECOMP '$1' | $AOPEN ) || RETVAL=1"
		;;
	uuencode)
		$VERBOSE >&2 "( $DECOMP '$1' | uudecode ) || RETVAL=1"
		$DO >&2 "( $DECOMP '$1' | uudecode ) || RETVAL=1"
		;;
	compress)
		if	[ "X$1" = "X$RESULT" ]
		then	mv -f "$1" "$1.$CSUFFIX"
			$VERBOSE $DECOMP < "$1.$CSUFFIX" > "$RESULT"
			$DO $DECOMP < "$1.$CSUFFIX" > "$RESULT"
		else	$VERBOSE $DECOMP < "$1" > "$RESULT
			$DO $DECOMP < "$1" > "$RESULT
		fi
		;;
	esac
}

while getopts nvV i
do
	case "$i" in
	n)	DO="echo";;
	v)	VERBOSE="echo";;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

for i
do
	if	[ ! -r "$i" ]
	then	j=`echo "$i"*`
		case "$j" in
		*\ *)	echo >&2 "Multiple matches for '$i'.  Aborting."
			;;
		"")	echo >&2 "Couldn't find '$i'.  Aborting."
			;;
		*)	;;
		esac
	else	j="$i"
	fi
	echo $N >&2 "Processing '$j'... $C"
	RETRY="Y"
	while	[ "X$RETRY" = "XY" ]
	do
		RETRY="N"
		if	id "$j" && result "$j"
		then	$VERBOSE >&2 "($NAME) \c"
			echo >&2 "Expect to get $TDIR/$RESULT."
			BACK=`pwd`
			case "$j" in
			/*)	;;
			*)	j="$BACK/$j";;
			esac
			cd "$TDIR"
			proc "$j"
			cd "$BACK"
		else	echo >&2 "can't identify it."
			RETVAL=1
		fi
		RETRY="N"
	done
done
