/* Started Dec 5, 1994 at Xerox.
 * All wrongs reversed. */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "version.h"

#ifdef __USLC__
extern int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif

int
main(int argc, char *argv[]) {
	char **newargv = NULL;
	char *s;
	int newargc;
	int loopflag = 0;
	int i;
	struct timeval timeout, timetwo;
	unsigned long length;

	if (argc > 1 && argv[1] && !strcmp(argv[1], "-V"))
		version();

	if (argc < 2) {
		fprintf(stderr, "usage: napper [-V] time [command]\n");
		exit(1);
	}

	if (argc > 2) {
		newargc = argc - 2;
		newargv = malloc((newargc + 1) * sizeof(char *));
		for (i = 0; i < newargc; ++i) {
			s = argv[i + 2];
			newargv[i] = malloc(strlen(s) + 1);
			strcpy(newargv[i], s);
		}
		newargv[newargc] = NULL;
		loopflag = 1;
	}

	length = strtol(argv[1], NULL, 0) * 1000;

	timeout.tv_sec = length / 1000000;
	timeout.tv_usec = length % 1000000;

	if (loopflag) {
		/* save timeout for use with systems that corrupt it in
		 * select */
		timetwo = timeout;
		while (1) {
			if (!fork()) {
				execvp(newargv[0], newargv);
				exit(1);
			} else {
				wait(NULL);
			}
			select(0, NULL, NULL, NULL, &timeout);
			/* restore timeout (see above) */
			timeout = timetwo;
		}
	} else {
		select(0, NULL, NULL, NULL, &timeout);
	}
	return 0;
}
