ALL="N"
TEST="-f"

usage() {
	echo >&2 "usage: findfile [-aV] [-d|-x] [-p path] file ..."
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

if [ $# -lt 1 ]
then	usage
fi

while getopts "adxp:V" o
do	case "$o" in
	a)	ALL="Y";;
	d)	case "$TEST" in
		-x)	usage;;
		esac
		TEST="-d"
		;;
	p)	SP="$OPTARG"
		;;
	x)	case "$TEST" in
		-d)	usage;;
		esac
		TEST="-x"
		case "$SP" in
		"")	SP="$SAVEPATH";;
		esac
		;;
	V)	version;;
	\?)	usage
		;;
	esac
done
shift `expr $OPTIND - 1`

case "$SP!$FILEPATH" in
""!?*)	SP="$FILEPATH";;
""!"")	SP=".:$HOME";;
?*!*)	;;
esac

for j
do	for i in `echo $SP | tr ':' ' '`
	do
		if [ "$TEST" "$i/$j" ]
		then	
			echo "$i/$j"
			case "$ALL" in
			N)	exit 0;;
			esac
		fi
	done
done
