CPIO="N"
RETVAL=0
LOG="N"
VERBOSE="N"
BAK="Y"
DIR=.
tmp=/tmp/.shlog.$$

usage() {
	echo >&2 "usage: filter [-cFlvV] [-d dir] [-s suffix] command [file ...]"
	exit 1
}

version() {
	echo >&2 "$0: utils revision VERSION"
	exit 0
}

while getopts cd:lFs:vV i
do
	case $i in
	c)	CPIO="Y";;
	d)	DIR="$OPTARG"
		CPIO="YUP"
		;;
	l)	LOG="Y";;
	F)	CPIO="YUP"
		;;
	s)	case "$OPTARG" in
		.*)	SUFFIX="$OPTARG";;
		*)	SUFFIX=".$OPTARG";;
		esac
		CPIO="YUP"
		;;
	v)	VERBOSE="Y";;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

if	[ X"$CPIO" = "XYUP" ]
then	case "$SUFFIX" in
	"")	 FIND="find '$DIR' -type f -print ";;
	*)	 FIND="find '$DIR' -type f -name '*$SUFFIX' -print ";;
	esac
fi

if [ $# -lt 1 ]
then	usage
else	case $CPIO in
	"N")	MINUSMINUS="N"
		for j
		do
			case $j in
			--)	MINUSMINUS="Y"
				;;
			esac
		done
		case $MINUSMINUS in
		"Y")	while [ "X$1" != "X--" ]
			do
				COMMAND="${COMMAND} \"$1\""
				shift
			done
			shift
			;;
		*)	COMMAND=$1
			shift
			;;
		esac
		;;
	*)	COMMAND="$*";;
	esac
fi

[ "$LOG" = "Y" ] && >$tmp

proc() {
	for i
	do
		if [ -r "$i" ]
		then	[ "$VERBOSE" = "Y" ] && echo >&2 "$i"
			PATH="$SAVEPATH" eval $COMMAND < "$i" || RETVAL=1
		else	echo >&2 "$0: Cannot read \`$i'."
			RETVAL=1
		fi
	done
}

case $CPIO in
"YUP")	eval $FIND | while read i
	do	proc "$i"
	done
;;
"Y")	while read i
	do	proc "$i"
	done
;;
"N")	if	[ $# -eq 0 ]
	then	eval $COMMAND || RETVAL=1
	else	proc "$@"
	fi
;;
esac

if [ "$LOG" = "Y" ]
then	cat $tmp
	rm -f $tmp
fi

exit $RETVAL
