#define _POSIX_SOURCE
#define _POSIX_C_SOURCE 2
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "opts.h"
#include "version.h"

void usage(void);

void
usage(void) {
	fprintf(stderr, "usage: ctimer [-V] [-f format] [ time ... ]\n");
	exit(EXIT_FAILURE);
}

int
main(int argc, char *argv[]) {
	char *fmt = NULL;
	char buf[1024];
	int i;
	int opt;
	time_t t;

	while ((opt = optsopt(argc, argv, "f:V")) != -1) {
		switch (opt) {
		case 'f':
			fmt = optsarg;
			break;
		case 'V':
			version();
			break;
		case '?':
			usage();
			break;
		}
	}

	if (fmt == NULL)
		fmt = "%c";

	if (optsind < argc) {
		for (i = optsind; i < argc; ++i) {
			t = strtol(argv[i], 0, 0);
			strftime(buf, 1024, fmt, localtime(&t));
			printf("%s\n", buf);
		}
	} else {
		while (scanf("%ld", &t) == 1) {
			strftime(buf, 1024, fmt, localtime(&t));
			printf("%s\n", buf);
		}
	}
	return 0;
}
