/* Started Dec 5, 1994 at Xerox.
 * All wrongs reversed. */
/* counting is non-trivial. */
/*
 * This is not a good example of programming style.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "version.h"

/* options supported:
** +n - start at n
** n - count to (sign of step) n + (start) (>n if step > 0, <n if step < 0)
** =n - count exactly to n
 * +n-n... | -n+n... - use pattern for steps
** -x - default to hex
** -0 - pad with leading 0's
** -r - right adjust
** -l - left adjust
** -p - prefix
** -P - postfix
** -s - specify step (-s n) (not used for multiple steps)
 * "string - count using string as format string (one %d/%x/et al. allowed)
** -n - use ' ', not '\n'
 */

char *myname;

int counts, counter;
int flagx, flag0, flagn, flageq, flagr, flagl, flagnop;
int start, done;
char *format = NULL, *prefix = NULL, *postfix = NULL;
int steps[16], stepc = 0, stepsn = 0, stepmn = 0, stepmx = 0;

static void warn(char *, ...);
int parse_args(int, char *[]);

static void
warn(char *s, ...) {
	va_list ap;
	fprintf(stderr, "%s: warning: ", myname);
	va_start(ap, s);
	vfprintf(stderr, s, ap);
	va_end(ap);
	fputc('\n', stderr);
}

int
parse_args(int argc, char *argv[]) {
	int i, j;
	int set_count = 0;
	char *s, *t;

	for (i = 1; i < argc; ++i) {
		if (!*argv[i])
			continue;
		if ((*argv[i] == '-' || *argv[i] == '+') &&
		   (strchr(argv[i] + 1, '+') || strchr(argv[i] + 1, '-'))) {
			if (stepc > 0) {
				warn("steps reset");
			}
			s = argv[i];
			stepsn = 0;

			j = 0;

			while ((j < 16) && *s) {
				t = s;
				steps[j] = strtol(s, &s, 0);
				if (s <= t && *s) {
					warn("ignoring garbage from '%s'...",
						s);
				}
				++stepc;
				stepsn += steps[j];
				if (stepsn < stepmn)
					stepmn = stepsn;
				if (stepsn > stepmx)
					stepmx = stepsn;

				++j;
			}
			if (j == 16 && *s) {
				warn("only 16 steps allowed, ignoring '%s'...",
					s);
			}
		} else if (*argv[i] == '-') {
			for (s = argv[i] + 1; *s; ++s) {
				switch (*s) {
				case '0':
					if (flag0)
						warn("flag0 already set.");
					flag0 = 1;
					break;
				case 'r':
					if (flagr)
						warn("flagr already set.");
					flagr = 1;
					break;
				case 'l':
					if (flagl)
						warn("flagl already set.");
					flagl = 1;
					break;
				case 'V':
					version();
					break;
				case 'x':
					if (flagx)
						warn("flagx already set.");
					flagx = 1;
					break;
				case 'X':
					if (flagx)
						warn("flagx already set.");
					flagx = 2;
					break;
				case 'n':
					if (flagn)
						warn("flagn already set.");
					flagn = 1;
					break;
				case 'P':
					free(postfix);
					if (s[1]) {
						postfix = malloc(strlen(s));
						strcpy(postfix, s + 1);
						s += strlen(s) - 1;
					} else { 
						postfix = malloc(strlen(argv[i + 1]) + 1);
						strcpy(postfix, argv[i + 1]);
						*argv[i + 1] = 0;
					}
					break;
				case 'p':
					free(prefix);
					if (s[1]) {
						prefix = malloc(strlen(s));
						strcpy(prefix, s + 1);
						s += strlen(s) - 1;
					} else { 
						prefix = malloc(strlen(argv[i + 1]) + 1);
						strcpy(prefix, argv[i + 1]);
						*argv[i + 1] = 0;
					}
					break;
				case 's':
					if (stepc)
						warn("resetting step.");
					stepc = 1;
					t = argv[i + 1];
					steps[0] = strtol(t, &t, 0);
					if (t <= argv[i + 1]) {
						warn("'%s' does not look like a number to me", argv[i + 1]);
						stepc = 0;
						steps[0] = 0;
						stepsn = 0;
						stepmn = 0;
						stepmx = 0;
					} else {
						stepsn = steps[0];
						stepmn = steps[0];
						stepmx = steps[0];
					}
					*argv[i + 1] = 0;
					break;
				default:
					if (!(counts = strtol(argv[i] + 1, &s, 0)))
						warn("unknown flag '%c'", *s);
					else {
						counts = -counts;
						set_count = 1;
						--s;
					}
					break;
				}
			}
		} else if (*argv[i] == '+') {
			s = argv[i] + 1;
			start = strtol(s, &s, 0);
			if (s <= argv[i] + 1) {
				warn("'%s' does not look like a number to me.", argv[i] + 1);
			}
			set_count = 1;
		} else if (*argv[i] == '=') {
			flageq = 1;
			if (counts) {
				warn("counts set more than once.\n");
			}
			s = argv[i] + 1;
			counts = strtol(s, &s, 0);
			if (s <= argv[i] + 1) {
				counts = 0;
				warn("'%s' does not look like a number to me.", argv[i] + 1);
			}
			set_count = 1;
		} else {
			s = argv[i];
			t = s;
			strtol(s, &s, 0);
			if (s > t) {
				counts = strtol(argv[i], NULL, 0);
				set_count = 1;
			} else {
				free(format);

				t = argv[i];

				if (*t == '"')
					++t;

				s = t + strlen(t) - 1;
				if ((t > argv[i]) && *s == '"')
					*s-- = '\0';
				format = malloc(s - t + 7);

				sprintf(format, "%%s%s%%s%%c", t);
				j = 0;
				for (s = t; *s; ++s)
					if (*s == '%')
						++j;
				if (!(j % 2))
					flagnop = 1;
			}
		}
	}
	if (!set_count) {
		warn("Error; you must set a target.");
		return 1;
	}
	return 0;
}

int
main(int argc, char *argv[]) {
	int i;
	char *s;

	if (argc < 2) {
		fprintf(stderr, "usage: count [-V] [-n] [-0] [-x] [+<n>] [=<n>] [\"format\"] [<n>]\n");
		exit(1);
	}
	myname = strrchr(argv[0], '/');
	myname = myname ? myname + 1 : argv[0];

	if (!parse_args(argc, argv)) {
		if (!stepc) {
			stepc = 1;
			steps[0] = 1;
			stepsn = 1;
			stepmn = 1;
			stepmx = 1;
		}

		if (!stepsn) {
			fprintf(stderr, "critical failure - counting by 0 will never get anywhere.  aborting!\n");
			exit(1);
		}

		if (!format) {
			if (flag0 || flagr || flagl) {
				int tmax = (counts >= 0 ? counts + stepmx :
					counts - stepmn);
				if ((tmax > 0 && start > tmax) || (tmax < 0 && start < tmax))
					tmax = start;
				if (tmax < 0)
					i = 1;
				else
					i = 0;
				for (; tmax; tmax /= (flagx ? 16 : 10))
					++i;
				format = malloc(20);
				sprintf(format, "%%s%%%s%dd%%s%%c", flag0 ? "0" :
					flagl ? "-" : "", i);
			} else {
				format = malloc(9);
				strcpy(format, "%s%d%s%c");
			}

			if (flagx) {
				done = 0;
				for (s = format + 2; *s && !done; ++s) {
					if (*s == '%') {
						++s;
						while (*s && !strchr("%cdixu", *s))
							++s;
						if (*s) {
							if (strchr("cdixu", *s)) {
								done = 1;
								*s = flagx == 2 ? 'X' : 'x';
							}
						}
					}
				}
				done = 0;
			}
		}

		if (!prefix)
			prefix = "";

		if (!postfix)
			postfix = "";

		counter = start;
		counts = counts + start - 1;
		i = 0;
		if (counts == counter)
			done = 2;

		if (stepsn > 0) {
			if (counter + stepmn > counts && counter != counts) {
				fprintf(stderr, "unreachable target - aborting.\n");
				exit(1);
			}
		} else {
			if (counter + stepmx < counts && counter != counts) {
				fprintf(stderr, "unreachable target - aborting.\n");
				exit(1);
			}
		}

		if (!flagnop) {
			printf(format, prefix, counter, postfix,
				flagn ? ' ' : '\n');
		} else {
			printf(format, prefix, postfix,
				flagn ? ' ' : '\n');
		}

		while (!done) {
			counter += steps[i++];
			i %= stepc;
			if (!flagnop) {
				printf(format, prefix, counter, postfix,
					flagn ? ' ' : '\n');
			} else {
				printf(format, prefix, postfix,
					flagn ? ' ' : '\n');
			}
			if (flageq) {
				if (counter == counts)
					done = 1;
				else if (!i) {
					if (stepsn > 0) {
						if (counter + stepmn > counts) {
							fprintf(stderr, "missed it completely.\n");
							exit(1);
						}
					} else {
						if (counter + stepmx < counts) {
							fprintf(stderr, "missed it completely.\n");
							exit(1);
						}
					}
				}
			} else {
				if (stepsn < 0 && counter <= counts)
					done = 1;
				if (stepsn > 0 && counter >= counts)
					done = 1;
			}
			if (done && flagn)
				putchar('\n');
		}
		return 0;
	} else
		return 1;
}
