VERBOSE="N"
SHELL="/bin/sh"
GROUP="user"
HOMEDIR=""
GECOS=""

usage() {
	echo >&2 "usage: adduser [-s shell] [-g group] [-H homedir] [-G gecos] [-u uid] username"
	exit 1
}

version() {
	echo >&2 "utils revision VERSION"
	exit 0
}

while getopts s:g:H:G:u: i
do
	case $i in
	s)	SHELL="$OPTARG";;
	g)	GROUP="$OPTARG";;
	G)	GECOS="$OPTARG";;
	H)	HOMEDIR="$OPTARG";;
	v)	VERBOSE="Y";;
	V)	version;;
	\?)	usage;;
	esac
done
shift `expr $OPTIND - 1`

USER="$1"

if [ -z "$GECOS" ]
then	GECOS="$USER"
fi

if [ -z "$HOMEDIR" ]
then	HOMEDIR="/usr/home/$USER"
fi

FAIL=0

if [ -d "$HOMEDIR" ]
then	FAIL=1
	ERROR="homedir already exists, ignored"
fi

if 	grep "^$USER:" /etc/passwd >/dev/null 2>&1
then	FAIL=1
	ERROR="user already in password file, ignored"
fi

PWE="$user::"

echo >&2 "not finished yet, ignoring your request"

exit 1
